from machine import Pin,PWM,ADC   
from utime import sleep
import neopixel

left=ADC(Pin(35))
right=ADC(Pin(34))
button = Pin(18,Pin.IN)
RGB_pin = Pin(25, Pin.OUT)
np = neopixel.NeoPixel(RGB_pin, n=4, bpp=3, timing=1)
def setup():
    for i in range(0,4):
        np[i] = (0,0,0)
    np.write()
    
def Map(x, in_min, in_max, out_min, out_max):
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min

def loop():
    while button.value() == 1:
        pass
    else:
        while True:
            ADC_L=left.read()
            ADC_R=right.read()
            print("ADC_L:",ADC_L)
            print("ADC_R:",ADC_R)
            sleep(0.2);
            ADC_SUM = ADC_L + ADC_R
            ADC_Now = 1000
            brightness_value = Map(ADC_SUM,ADC_Now,8190,0,1)
            for n in range(0,4):
                rgb_red = int(255*brightness_value)
                rgb_green = int(255*brightness_value)
                rgb_blue = int(255*brightness_value)
                np[n] = (rgb_red,rgb_green,rgb_blue)
            np.write()
            sleep(0.1)
if __name__ == "__main__":
    setup()
    loop()